/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import jpcsp.network.protocols.IPv4;
import jpcsp.network.protocols.InternetChecksum;
import jpcsp.network.protocols.NetPacket;
import jpcsp.util.Utilities;

public class TCP {
    public int sourcePort;
    public int destinationPort;
    public int sequenceNumber;
    public int acknowledgmentNumber;
    public int dataOffset;
    public int reserved;
    public boolean flagNS;
    public boolean flagCWR;
    public boolean flagECE;
    public boolean flagURG;
    public boolean flagACK;
    public boolean flagPSH;
    public boolean flagRST;
    public boolean flagSYN;
    public boolean flagFIN;
    public int windowSize;
    public int checksum;
    public int urgentPointer;
    public byte[] options;
    public byte[] data;

    public TCP() {
        this.dataOffset = 5;
        this.windowSize = 16384;
    }

    public TCP(TCP tcp) {
        this.sourcePort = tcp.sourcePort;
        this.destinationPort = tcp.destinationPort;
        this.sequenceNumber = tcp.sequenceNumber;
        this.acknowledgmentNumber = tcp.acknowledgmentNumber;
        this.dataOffset = tcp.dataOffset;
        this.reserved = tcp.reserved;
        this.flagNS = tcp.flagNS;
        this.flagCWR = tcp.flagCWR;
        this.flagECE = tcp.flagECE;
        this.flagURG = tcp.flagURG;
        this.flagACK = tcp.flagACK;
        this.flagPSH = tcp.flagPSH;
        this.flagRST = tcp.flagRST;
        this.flagSYN = tcp.flagSYN;
        this.flagFIN = tcp.flagFIN;
        this.windowSize = tcp.windowSize;
        this.checksum = tcp.checksum;
        this.urgentPointer = tcp.urgentPointer;
        this.options = tcp.options;
        this.data = tcp.data;
    }

    public void swapSourceAndDestination() {
        int port = this.sourcePort;
        this.sourcePort = this.destinationPort;
        this.destinationPort = port;
    }

    public void computeChecksum(IPv4 ipv4) throws EOFException {
        this.checksum = 0;
        NetPacket checksumPacket = new NetPacket(12 + this.sizeOf());
        checksumPacket.writeBytes(ipv4.sourceIPAddress);
        checksumPacket.writeBytes(ipv4.destinationIPAddress);
        checksumPacket.write8(0);
        checksumPacket.write8(ipv4.protocol);
        checksumPacket.write16(this.sizeOf());
        this.write(checksumPacket);
        this.checksum = InternetChecksum.computeInternetChecksum(checksumPacket.getBuffer(), 0, checksumPacket.getOffset());
    }

    private int getOptionsLength() {
        return Math.max((this.dataOffset - 5) * 4, 0);
    }

    public void read(NetPacket packet) throws EOFException {
        this.sourcePort = packet.read16();
        this.destinationPort = packet.read16();
        this.sequenceNumber = packet.read32();
        this.acknowledgmentNumber = packet.read32();
        this.dataOffset = packet.readBits(4);
        this.reserved = packet.readBits(3);
        this.flagNS = packet.readBoolean();
        this.flagCWR = packet.readBoolean();
        this.flagECE = packet.readBoolean();
        this.flagURG = packet.readBoolean();
        this.flagACK = packet.readBoolean();
        this.flagPSH = packet.readBoolean();
        this.flagRST = packet.readBoolean();
        this.flagSYN = packet.readBoolean();
        this.flagFIN = packet.readBoolean();
        this.windowSize = packet.read16();
        this.checksum = packet.read16();
        this.urgentPointer = packet.read16();
        this.options = packet.readBytes(this.getOptionsLength());
        this.data = packet.readBytes(packet.getLength());
    }

    public NetPacket write(NetPacket packet) throws EOFException {
        packet.write16(this.sourcePort);
        packet.write16(this.destinationPort);
        packet.write32(this.sequenceNumber);
        packet.write32(this.acknowledgmentNumber);
        packet.writeBits(this.dataOffset, 4);
        packet.writeBits(this.reserved, 3);
        packet.writeBoolean(this.flagNS);
        packet.writeBoolean(this.flagCWR);
        packet.writeBoolean(this.flagECE);
        packet.writeBoolean(this.flagURG);
        packet.writeBoolean(this.flagACK);
        packet.writeBoolean(this.flagPSH);
        packet.writeBoolean(this.flagRST);
        packet.writeBoolean(this.flagSYN);
        packet.writeBoolean(this.flagFIN);
        packet.write16(this.windowSize);
        packet.write16(this.checksum);
        packet.write16(this.urgentPointer);
        packet.writeBytes(this.options, 0, this.getOptionsLength());
        packet.writeBytes(this.data);
        return packet;
    }

    public NetPacket write() throws EOFException {
        return this.write(new NetPacket(this.sizeOf()));
    }

    public int sizeOf() {
        int size = this.dataOffset * 4;
        if (this.data != null) {
            size += this.data.length;
        }
        return size;
    }

    private void addFlagString(StringBuilder s, String flagName, boolean flagValue) {
        if (flagValue) {
            if (s.length() > 0) {
                s.append("|");
            }
            s.append(flagName);
        }
    }

    private String getFlagsString() {
        StringBuilder s = new StringBuilder();
        this.addFlagString(s, "NS", this.flagNS);
        this.addFlagString(s, "CWR", this.flagCWR);
        this.addFlagString(s, "ECE", this.flagECE);
        this.addFlagString(s, "URG", this.flagURG);
        this.addFlagString(s, "ACK", this.flagACK);
        this.addFlagString(s, "PSH", this.flagPSH);
        this.addFlagString(s, "RST", this.flagRST);
        this.addFlagString(s, "SYN", this.flagSYN);
        this.addFlagString(s, "FIN", this.flagFIN);
        return s.toString();
    }

    public String toString() {
        return String.format("sourcePort=0x%X, destinationPort=0x%X, sequenceNumber=0x%X, acknowledgmentNumber=0x%X, dataOffset=0x%X, reserved=0x%X, flags=%s, windowSize=0x%X, checksum=0x%04X, urgentPointer=0x%X, options=%s, data=%s", this.sourcePort, this.destinationPort, this.sequenceNumber, this.acknowledgmentNumber, this.dataOffset, this.reserved, this.getFlagsString(), this.windowSize, this.checksum, this.urgentPointer, Utilities.getMemoryDump(this.options, 0, this.getOptionsLength()), Utilities.getMemoryDump(this.data));
    }
}

